<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Profili {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $descrizione;
        private $aspetto;
        private $aspectRatio;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $descrizione="", $aspetto="", $aspectRatio="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->descrizione = $descrizione;
            $this->aspetto = $aspetto;
            $this->aspectRatio = $aspectRatio;
        }

        function crea() {
            $query    = "INSERT INTO `geec_visualizzatoriProfili` (`id`, `nome`, `mostraNome`, `spazioOccupato`, `descrizione`, `aspetto`, `aspectRatio`) 
                            VALUES (NULL, '$this->nome', 'si', '$this->spazioOccupato', '$this->descrizione', '$this->aspetto', '$this->aspectRatio');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_visualizzatoriProfili SET nome='$this->nome', descrizione='$this->descrizione', spazioOccupato='$this->spazioOccupato', aspetto='$this->aspetto', aspectRatio='$this->aspectRatio' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_visualizzatoriProfili",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 34
            eliminaOccorrenzeComponente($this->db,$this->id,34);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_visualizzatoreProfili VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_profili WHERE idVisualizzatoreProfili='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_profili` (`id`, `idVisualizzatoreProfili`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_profili WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_profili SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_profili SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiGriglia   = $this->db->leggiSingolaRiga("geec_visualizzatoriProfili",$this->id);
            $this->nome              = $datiGriglia["nome"];
            $this->descrizione       = $datiGriglia["descrizione"];
            $this->spazioOccupato    = $datiGriglia["spazioOccupato"];
            $this->aspetto    = $datiGriglia["aspetto"];
            $this->aspectRatio = $datiGriglia["aspectRatio"];
        }
        
        function creaElemento($nome,$ruolo,$descrizione) {
            $queryPosizione = "SELECT * FROM geec_profili WHERE idVisualizzatoreProfili=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_profili` (`id`, `idVisualizzatoreProfili`, `posizione`, `nome`, `immagine`, `ruolo`, `azienda`, `email`, `descrizione`, `facebook`, `instagram`, `twitter`, `linkedin`) "
                    . "VALUES (NULL, '$this->id', '$posizione', '$nome', 'immagini/altro/segnaposto.png', '$ruolo', '','','$descrizione','','','','')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            $query = "SELECT * FROM geec_profili WHERE idVisualizzatoreProfili = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <div class="aspect-ratio-21-9">
                              <img src="../../../<?php echo $elemento["immagine"] ?>">
                            </div>
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["nome"] ?></strong></a></em></p>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $elemento["nome"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome, $ruolo, $azienda, $email, $descrizione,$facebook,$instagram,$twitter,$linkedin) {
            $query = "UPDATE geec_profili SET nome='$nome', azienda='$azienda', ruolo='$ruolo', email='$email', descrizione='$descrizione', facebook='$facebook', instagram='$instagram', twitter='$twitter', linkedin='$linkedin' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_profili` SET  immagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_profili WHERE idVisualizzatoreProfili=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_profili SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_profili SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_profili",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getAspetto() {
            return $this->aspetto;
        }

        public function getAspectRatio() {
            return $this->aspectRatio;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setDescrizione($descrizione): void {
            $this->descrizione = $descrizione;
        }

        public function setAspetto($aspetto): void {
            $this->aspetto = $aspetto;
        }

        public function setAspectRatio($aspectRatio): void {
            $this->aspectRatio = $aspectRatio;
        }

    }